<?php
include 'conn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $vards = $conn->real_escape_string($_POST['vards']);
  $uzvards = $conn->real_escape_string($_POST['uzvards']);
  $dzimene = $conn->real_escape_string($_POST['dzimene']);
  $vecums = $_POST['vecums'];

  if (isset($_POST['intereses']) && is_array($_POST['intereses'])) {
    $escaped_intereses = array_map(function($interese) use ($conn) {
      return $conn->real_escape_string($interese);
    }, $_POST['intereses']);

    $intereses_str = implode(',', $escaped_intereses);
  } else {
    $intereses_str = '';
  }

  $transports_str = $conn->real_escape_string($_POST['transports']);
  $dzimums_str = $conn->real_escape_string($_POST['dzimums']);

  $masinas = '';
  if ($transports_str == 'Mašīna' && isset($_POST['masinas'])) {
    $masinas = $conn->real_escape_string($_POST['masinas']);
  }

  $sql = "INSERT INTO rihards (vards, uzvards, dzimene, vecums, intereses, transports, dzimums, masinas) 
          VALUES ('$vards', '$uzvards', '$dzimene', '$vecums', '$intereses_str', '$transports_str', '$dzimums_str', '$masinas')";

  if ($conn->query($sql) === TRUE) {
    echo "Pievienoja lietotāju " . $vards;
    header("Refresh: 1; URL=tabula.php");
    exit;
  } else {
    $error = "Kļūda: " . $conn->error;
  }
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Jauns lietotājs</title>
  <script>
    function toggleMasinasField() {
      var transports = document.getElementById("transports").value;
      var masinasField = document.getElementById("masinasField");
      if (transports === "Mašīna") {
        masinasField.style.display = "block";
      } else {
        masinasField.style.display = "none";
      }
    }
  </script>
</head>
<body>
  <h1>Jauns lietotājs</h1>
  <form action="ievade.php" method="POST">
    <label for="vards">Vārds:</label><br>
    <input type="text" id="vards" name="vards" required><br><br>

    <label for="uzvards">Uzvārds:</label><br>
    <input type="text" id="uzvards" name="uzvards" required><br><br>

    <label for="dzimene">Dzimene:</label><br>
    <input type="date" id="dzimene" name="dzimene" required><br><br>

    <label for="vecums">Vecums:</label><br>
    <input type="number" id="vecums" name="vecums" min="1" required><br><br>

    <label>Intereses:</label><br>

    <input type="checkbox" id="interese_sports" name="intereses[]" value="Sports">
    <label for="interese_sports">Sports</label><br>

    <input type="checkbox" id="interese_lasisana" name="intereses[]" value="Lasīšana">
    <label for="interese_lasisana">Lasīšana</label><br>

    <input type="checkbox" id="interese_dators" name="intereses[]" value="Dators">
    <label for="interese_dators">Dators</label><br>

    <input type="checkbox" id="interese_celosana" name="intereses[]" value="Ceļošana">
    <label for="interese_celosana">Ceļošana</label><br>

    <br>
    <label for="transports">Pārvietošanās veids:</label>
    <select id="transports" name="transports" onchange="toggleMasinasField()" required>
      <option value="Mašīna">Mašīna</option>
      <option value="Vilciens">Vilciens</option>
      <option value="Tramvajs">Tramvajs</option>
      <option value="Ritenis">Ritenis</option>
      <option value="Lidmašīna">Lidmašīna</option>
    </select>

    <br><br>
    <div id="masinasField" style="display:none;">
      <label for="masinas">Mašīnas marka:</label><br>
      <select id="masinas" name="masinas">
        <option value="Audi">Audi</option>
        <option value="BMW">BMW</option>
        <option value="Opel">Opel</option>
        <option value="Mitsubishi">Mitsubishi</option>
        <option value="Toyota">Toyota</option>
        <option value="Honda">Honda</option>
        <option value="Hyundai">Hyundai</option>
        <option value="Mercedes">Mercedes</option>
        <option value="Pagani">Pagani</option>
        <option value="Koenigsegg">Koenigsegg</option>
        <option value="Peel">Peel</option>
        <option value="Ford">Ford</option>
      </select><br><br>
    </div>

    <label for="dzimums">Dzimums</label>
    <select id="dzimums" name="dzimums">
      <option value="Vīrietis">Vīrietis</option>
      <option value="Sieviete">Sieviete</option>
      <option value="Neteikšū">Neteikšu</option>
    </select>

    <br><br>
    <button type="submit">Pievienot</button>
  </form>
</body>
</html>
